<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Trophy extends Model 
{

    protected $table = 'trophies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('year', 'name');

    public function athletes()
    {
        return $this->belongsTo('App\Models\Athlete');
    }

}